<?php


class ControllerExtensionPaymenteBekero extends Controller {
	public function index() {
		$this->load->model('checkout/order');
		$this->load->language('extension/payment/ebekero');
		$this->load->library('ebekero/ebekero');

		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

		$data['creditor_email'] = $this->config->get('payment_ebekero_creditor');
		$data['creditor_name']	= $this->config->get('payment_ebekero_creditor_name');
		$data['creditor_bban']	= $this->config->get('payment_ebekero_creditor_bban');

		$data['debtor_email']	= $order_info['email'];
		$data['debtor_name']	= $order_info['payment_lastname']." ".$order_info['payment_firstname'];
		$data['amount']			= $order_info['total'];
		$data['order_id']		= $order_info['order_id'];

		$data['amount_text']	= number_format($order_info['total'], 0, '.', ' ');

		$data['callback']		= $this->url->link('extension/payment/ebekero/notify', '', true);

		if ($this->config->get('payment_ebekero_test'))
			$data['apiserver'] = $this->ebekero::SRV_SANDBOX;
		else
			$data['apiserver'] = $this->ebekero::SRV_LIVE;




		return $this->load->view('extension/payment/ebekero', $data);
	}

	public function notify() {

		$this->load->language('extension/payment/ebekero');
		$this->load->model('extension/payment/ebekero');
		$this->load->library('ebekero/ebekero');

		if (isset($this->request->get['reference']))
			$reference = $this->request->get['reference'];
		else {
			echo 'no ref';
			return;
		};

		$admin = 0;
		if (isset($this->request->get['admin']))
			$admin = $this->request->get['admin'];

			if ($this->config->get('payment_ebekero_test'))
				$this->ebekero->setMode($this->ebekero::SANDBOX);
			else
				$this->ebekero->setMode($this->ebekero::LIVE);

		$this->ebekero->setCreditor($this->config->get('payment_ebekero_creditor'));
		$this->ebekero->setReference($reference);
		$this->ebekero->status();



		//if($this->ebekero->errorcode) return;

		$order_id = $this->ebekero->getCustom();

		$this->load->model('checkout/order');
		$this->load->model('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($order_id);


		if ($order_info) {
			$log = new Log('ebekero.log');
			$log->write('ebekero-> ' . json_encode($this->ebekero));

			$msg = 'eBekérő #'.$reference.': ';

			$self_states = [
				$this->config->get('payment_ebekero_order_status_id_drop'),
				$this->config->get('payment_ebekero_order_status_id_success'),
				$this->config->get('payment_ebekero_order_status_id_reject'),
				$this->config->get('payment_ebekero_order_status_id_recall')
			];

			$update = !in_array($order_info['order_status_id'], $self_states);

			$this->load->language('extension/payment/ebekero');

			switch($this->ebekero->getState()) {
				case $this->ebekero::STATE_INIT:
				case $this->ebekero::STATE_SENT:
				case $this->ebekero::STATE_ACK:
					if($order_info['order_status_id'] != $this->config->get('payment_ebekero_order_status_id'))
					$this->model_checkout_order->addOrderHistory($order_id,
						$this->config->get('payment_ebekero_order_status_id'),
						$msg.' '.$this->language->get('text_bekero_pending').' <a target="_blank" href="'.$this->url->link('extension/payment/ebekero/notify', '', true).'&reference='.$reference.'&admin=1">'.$this->language->get('text_bekero_force_check').'</a>'
					);

					if(!$admin) echo '<html><head><title>eBekérő</title><meta http-equiv="refresh" content="10"></head><body><h2>'.$this->language->get('text_bekero_do_not_close').'</h2></body></html>';
					break;
				case $this->ebekero::STATE_DROP:
					if($update) $this->model_checkout_order->addOrderHistory($order_id,
						$self_states[0],
						$msg.' '.$this->language->get('text_bekero_reject_system')
					);
					if(!$admin) $this->response->redirect($this->url->link('checkout/failure', '', true));
					break;
				case $this->ebekero::STATE_ACCEPT:
					if($update) $this->model_checkout_order->addOrderHistory($order_id,
						$self_states[1],
						$msg.' '.$this->language->get('text_bekero_accept')
					);
					if(!$admin) $this->response->redirect($this->url->link('checkout/success', '', true));
					break;
				case $this->ebekero::STATE_REJECT:
					if($update) $this->model_checkout_order->addOrderHistory($order_id,
						$self_states[2],
						$msg.' '.$this->language->get('text_bekero_reject_user')
					);
					if(!$admin) $this->response->redirect($this->url->link('checkout/failure', '', true));
					break;
				case $this->ebekero::STATE_RECALL:
					if($update) $this->model_checkout_order->addOrderHistory($order_id,
						$self_states[3],
						$msg.' '.$this->language->get('text_bekero_recall')
					);
					if(!$admin) $this->response->redirect($this->url->link('checkout/failure', '', true));
					break;
			}

			if($update) $log->write('state '.$this->ebekero->getState().' was written for #'.$order_id);

			echo $this->language->get('text_bekero_polled');


		}
	}
}
