<?php
class ControllerExtensionPaymenteBekero extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/payment/ebekero');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('payment_ebekero', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['creditor'])) {
			$data['error_creditor'] = $this->error['creditor'];
		} else {
			$data['error_creditor'] = '';
		}

		$data['creditor_bad_category'] =  $this->language->get('creditor_bad_category');
		$data['creditor_unknown'] =  $this->language->get('creditor_unknown');
		$data['creditor_ok'] =  $this->language->get('creditor_ok');
		$data['creditor_quota'] =  $this->language->get('creditor_quota');
		$data['method_name'] =  $this->language->get('method_name');
		$data['text_title'] =  $this->language->get('text_title');
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/payment/ebekero', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/payment/ebekero', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

		if (isset($this->request->post['payment_ebekero_creditor'])) {
			$data['payment_ebekero_creditor'] = $this->request->post['payment_ebekero_creditor'];
		} else {
			$data['payment_ebekero_creditor'] = $this->config->get('payment_ebekero_creditor');
		}


        if (isset($this->request->post['payment_ebekero_creditor_name'])) {
			$data['payment_ebekero_creditor_name'] = $this->request->post['payment_ebekero_creditor_name'];
		} else {
			$data['payment_ebekero_creditor_name'] = $this->config->get('payment_ebekero_creditor_name');
		}

        if (isset($this->request->post['payment_ebekero_creditor_bban'])) {
			$data['payment_ebekero_creditor_bban'] = $this->request->post['payment_ebekero_creditor_bban'];
		} else {
			$data['payment_ebekero_creditor_bban'] = $this->config->get('payment_ebekero_creditor_bban');
		}

		if (isset($this->request->post['payment_ebekero_method_name'])) {
			$data['payment_ebekero_method_name'] = $this->request->post['payment_ebekero_method_name'];
		} else {
			$data['payment_ebekero_method_name'] = $this->config->get('payment_ebekero_method_name');
		}

		$data['apiserver'] = 'https://api.ebekero.hu/';
		$data['jsbundle'] = HTTPS_CATALOG . 'catalog/view/javascript/ebekero/bundle.js';
		//$data['jsebekero'] = HTTPS_CATALOG . 'catalog/view/javascript/ebekero/ebekero.js';

		if (isset($this->request->post['payment_ebekero_test'])) {
			$data['payment_ebekero_test'] = $this->request->post['payment_ebekero_test'];
		} else {
			$data['payment_ebekero_test'] = $this->config->get('payment_ebekero_test');
		}

		if (isset($this->request->post['payment_ebekero_order_status_id'])) {
			$data['payment_ebekero_order_status_id'] = $this->request->post['payment_ebekero_order_status_id'];
		} else {
			$data['payment_ebekero_order_status_id'] = $this->config->get('payment_ebekero_order_status_id');
		}

        if (isset($this->request->post['payment_ebekero_order_status_id_drop'])) {
			$data['payment_ebekero_order_status_id_drop'] = $this->request->post['payment_ebekero_order_status_id_drop'];
		} else {
			$data['payment_ebekero_order_status_id_drop'] = $this->config->get('payment_ebekero_order_status_id_drop');
		}
        if (isset($this->request->post['payment_ebekero_order_status_id_reject'])) {
			$data['payment_ebekero_order_status_id_reject'] = $this->request->post['payment_ebekero_order_status_id_reject'];
		} else {
			$data['payment_ebekero_order_status_id_reject'] = $this->config->get('payment_ebekero_order_status_id_reject');
		}
        if (isset($this->request->post['payment_ebekero_order_status_id_recall'])) {
			$data['payment_ebekero_order_status_id_recall'] = $this->request->post['payment_ebekero_order_status_id_recall'];
		} else {
			$data['payment_ebekero_order_status_id_recall'] = $this->config->get('payment_ebekero_order_status_id_recall');
		}
        if (isset($this->request->post['payment_ebekero_order_status_id_success'])) {
			$data['payment_ebekero_order_status_id_success'] = $this->request->post['payment_ebekero_order_status_id_success'];
		} else {
			$data['payment_ebekero_order_status_id_success'] = $this->config->get('payment_ebekero_order_status_id_success');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['payment_ebekero_geo_zone_id'])) {
			$data['payment_ebekero_geo_zone_id'] = $this->request->post['payment_ebekero_geo_zone_id'];
		} else {
			$data['payment_ebekero_geo_zone_id'] = $this->config->get('payment_ebekero_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['payment_ebekero_status'])) {
			$data['payment_ebekero_status'] = $this->request->post['payment_ebekero_status'];
		} else {
			$data['payment_ebekero_status'] = $this->config->get('payment_ebekero_status');
        }

		if (isset($this->request->post['payment_ebekero_sort_order'])) {
			$data['payment_ebekero_sort_order'] = $this->request->post['payment_ebekero_sort_order'];
		} else {
			$data['payment_ebekero_sort_order'] = $this->config->get('payment_ebekero_sort_order');
        }

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/payment/ebekero', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/payment/ebekero')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['payment_ebekero_creditor']) {
			$this->error['creditor'] = $this->language->get('error_creditor');
		}

		return !$this->error;
	}
}
