<?php
namespace eBekero;

class eBekeroAPI {
    const SRV_SANDBOX   = 'https://sandbox.api.ebekero.hu/';
    const SRV_LIVE      = 'https://api.ebekero.hu/';
	const APIVERSION    = 'v0';

    const SANDBOX   = 'sandbox';
    const LIVE      = 'live';

    const API_OK    = 0;

    const STATE_INIT    = 0;
    const STATE_SENT    = 1;
    const STATE_ACK     = 2;
    const STATE_DROP    = 3;
    const STATE_ACCEPT  = 4;
    const STATE_REJECT  = 5;
    const STATE_RECALL  = 6;


	protected $language;
	protected $authkey;

    public $HOST;
	public $error;

	public function __construct() {
        $this->setMode(eBekeroAPI::LIVE);
		$this->language = 'hu';
		$this->authkey = 'public anonymous';
        $this->error = (object)['code'=>0, 'message'=>'API_OK', 'extra'=>''];
	}
    public function setMode($mode) {
        if($mode == eBekeroAPI::SANDBOX)
            $this->setHost(eBekeroAPI::SRV_SANDBOX);
        else
            $this->setHost(eBekeroAPI::SRV_LIVE);
    }
	public function setHost($host) {
		$this->HOST = $host;
		return 1;
	}
	public function setLanguage($language) {
		$this->language = $language;
		return 1;
	}
	public function setAuthkey($authkey) {
		$this->authkey = $authkey;
		return 1;
	}
	public function APIcall($endpoint = '', $obj = []) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $this->HOST.$endpoint);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode((object)$obj));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Authorization: '.$this->authkey,
			'Language: '.$this->language,
			'Version: '.eBekero::APIVERSION,
			'Content-type: application/json'
		));
        $response = curl_exec($ch);
		$response = @json_decode($response);

		if(isset($response->status))
            $this->error = $response->status;
		else
            $this->error = (object)['code'=>'666', 'status'=>'Cannot communicate.', 'extra'=>$response];

		curl_close($ch);

		return $response;
	}
    public function getCode() {
        return $this->error->code;
    }
}

class eBekero extends eBekeroAPI {
	protected $creditor;
	protected $amount;
	protected $debtor;

	protected $reference;
	protected $custom;
	protected $status;
	protected $reason;
	protected $concluded;

	public function __construct() {
		parent::__construct();

		$this->amount = 0;
		$this->creditor = '';
		$this->debtor = '';

		$this->reference = '';
		$this->status = -1;
		$this->reason = '';
		$this->concluded = '';
	}

	public function setCreditor($creditor) {
		$this->creditor = $creditor;
		return 1;
	}
	public function setAmount($amount) {
		$this->amount = $amount;
		return 1;
	}
	public function setDebtor($debtor) {
		$this->debtor = $debtor;
		return 1;
	}
	public function setReference($reference) {
		$this->reference = $reference;
		return 1;
	}
	public function quickfill($creditor, $debtor, $amount) {
		if( $this->setCreditor($creditor) &&
			$this->setAmount($amount) &&
			$this->setDebtor($debtor)
		) return 1;

		return 0;
	}



	public function getCreditor() {
		return $this->creditor;
	}
	public function getDebtor() {
		return $this->debtor;
	}
	public function getAmount() {
		return $this->amount;
	}
	public function getReference() {
		return $this->reference;
	}
	public function getCustom() {
		return $this->custom;
	}
	public function getState() {
		return $this->status;
	}
	public function getMessage() {
		return $this->message;
	}
	public function getConcluded() {
		return $this->concluded;
	}


	public function send() {
		if(!($this->creditor && $this->debtor && $this->amount)) return 0;

		$response = $this->APIcall('transaction/start',
                        (object)[
                            'creditor'=>$this->creditor,
                            'debtor'=>$this->debtor,
                            'amount'=>$this->amount
                        ]
        );
		if(isset($response->success)) {
            $this->reference = $response->reference;
            return $response->reference;
        } else return '';

	}
	public function status() {
		$req = (object)['reference'=>$this->reference];
		if($this->creditor)
		      $req->creditor = $this->creditor;

		$response = $this->APIcall('transaction/status', $req);

		if(isset($response->state))
			$this->status = $response->state;
		if(isset($response->message))
			$this->reason = $response->message;
		if(isset($response->debtor))
			$this->debtor = $response->debtor;
		if(isset($response->amount))
			$this->amount = $response->amount;
		if(isset($response->concluded))
			$this->concluded = $response->concluded;
		if(isset($response->custom))
			$this->custom = $response->custom;


		return $response;
	}
}

class Profil extends eBekeroAPI {
    protected $profile;
    protected $known;

    public function __construct($email = '', $bban = '', $name = '') {
        parent::__construct();
        $this->profile = (object)[];
        $this->known = false;

        if($email)  $this->set('email', $email);
        if($bban)   $this->set('bban', $bban);
        if($name)   $this->set('name', $name);
    }
    public function register() {
        $req = (object)[];

        if($this->profile->email) $req->email = $this->profile->email;
        if($this->profile->bban) $req->bban = $this->profile->bban;
        if($this->profile->name) $req->name = $this->profile->name;

        $response = $this->APIcall('profile/register', $req);

        if($response) if($response->status->code == 0) {
            $this->profile = (object)[];
            return $response;
        } else
            return false;
    }
    public function status() {
        $req = (object)[];

        if(isset($this->profile->email)) $req->email = $this->profile->email;
        if(isset($this->profile->bban)) $req->bban = $this->profile->bban;

        $response = $this->APIcall('profile/status', $req);

        if($response)
        if($response->status->code == 0) {
            $this->profile = (object)[];
            $this->known = $response->known;
            return $response;
        } else
            return false;
    }
    public function get($key) {
        if(isset($this->profile->{$key})) return $this->profile->{$key};
        else return false;
    }
	public function set($key, $value) {
		$this->profile->{$key} = $value;

	}
    public function isKnown() {
        return $this->known;
    }
}
