<?php
{
    extract($bekero);
?>

<div id="ebekero-container" >
    <div class="ebekero-half pull-right" id="ebekero1">
        <div class="ebekero-box">
            <a href="https://ebekero.hu" target="_blank" class="leadlink"><h3 class="logo">eBekérő fizetés</h3></a>
            <div class="body">
            <div class="row">
                <div class="cell lab">
                    <label class="inputname">Eladó</label>
                </div>
                <div class="cell">
                    <p class="smaller-pre"><?php echo $creditor_name; ?></p>
                    <p class="smaller" id="seller-mail"><?php echo $creditor_email; ?></p>
                    <small class="muted" id="seller-mail-message"></small>
                </div>
            </div>
            <div class="row">
                <div class="cell lab">
                    <label class="inputname">Összeg</label>
                </div>
                <div class="cell">
                    <p id="amount"><?php echo number_format($amount, 0, ',', ' '); ?> Ft</p>
                </div>
            </div>
            <div class="row">
                <div class="cell lab">
                    <label  class="inputname">Vevő</label>
                </div>
                <div class="cell">
                    <div>
                            <input type="email" id="buyer-mail" size="30" name="buyer-mail" placeholder="E-mail cím" value="<?php echo $debtor_email; ?>">
                            <small class="muted" id="buyer-mail-message"></small>
                    </div>
                    <div class="buyer-register-form">
                        <div>
                            <input type="text" id="buyer-name"  size="30" name="buyer_name" placeholder="Név" value="">
                            <small class="muted" id="buyer-name-message"></small>
                        </div>
                        <div>
                            <input type="text" id="buyer-ban"  size="30" name="buyer-ban" placeholder="Bankszámlaszám">
                            <small class="muted" id="buyer-ban-message"></small>
                        </div>
                        <div>
                            <input type="checkbox" class="form-check-input" id="buyer-eua" name="buyer_eua">
                            <label class="form-check-label" for="buyer-eua">A <a href="https://ebekero.hu/aszf" target="_blank">feltételeket</a> és az <a href="https://ebekero.hu/gdpr" target="_blank">adatkezelést</a> elfogadom. <span class="text-danger"></span></label>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="ebekero-motd">
        </div>
            <div style="text-align: center;">
            <button type="button" id="ebekero-send">eBekérő indítása</button>
        </div>
        </div>
    </div>
</div>

<link type="text/css" href="<?php echo $style; ?>" rel="stylesheet" media="screen" />

<script src="<?php echo $js_bundle; ?>"></script>




<script>

var $$;
var bekero;
var EBEKERO_API_HOST = '<?php echo $apiserver; ?>';

$$(function() {
    console.log('eBekero JS API selfloading with jQuery '+$$.fn.jquery);

    $$.get(EBEKERO_API_HOST + 'system/motd', function(motd) {
        $$('.ebekero-motd').hide();
        $$('.ebekero-motd').html(motd);
        $$('.ebekero-motd').slideDown();
    })

    $$('#ebekero1 #buyer-ban').inputmask('99999999-99999999[-99999999]');
    $$('#ebekero1 #buyer-ban').inputmask({"placeholder": ""});
    bekero = new eBekeroHalfGui();
    bekero.on_done = function() {
        setTimeout(function() {
            window.location.href = '<?php echo $callback; ?>&reference='+bekero.order.reference;
        }, 5000);
    }

    var first = true;
    bekero.on_statechange = function(bekero, resp) {
        if(bekero.order.status == 2 && first) {
            first = false;
            $$.get('<?php echo $callback; ?>'+'&reference='+bekero.order.reference, function() {
                console.log('notified for pending');
            });
        }
    }

    bekero.order.creditor.known = true;
    bekero.order.creditor.email = '<?php echo $creditor_email; ?>';

    bekero.populate_amount('<?php echo $amount; ?>');
    bekero.populate_debtor_email('<?php echo $debtor_email; ?>');
    bekero.populate_custom('<?php echo $order_id; ?>');
});


</script>

<?php
}
?>
