<?php
/*
Plugin Name: Woocommerce eBekérő integráció
Plugin URI: https://ebekero.hu/webshop
Description: WooCommerce integráció az eBekérő fizetési szolgáltatás használatához.
Author: eBekérő.hu
Author URI: https://ebekero.hu
Version: 1.4
*/


add_action( 'plugins_loaded', 'ebekero_init', 0 );
function ebekero_init() {
	if (!class_exists('WC_Payment_Gateway' )) return;
	include_once( 'ebekero-woocommerce.php' );

	add_filter( 'woocommerce_payment_gateways', 'ebekero_gateway');
	function ebekero_gateway( $methods ) {
		$methods[] = 'WC_eBekero_Payment_Gateway';
		return $methods;
	}
}

// Add custom action links
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'ebekero_action_links');
function ebekero_action_links($links) {
	$plugin_links = array(
		'<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout' ) . '">' . __( 'Beállítások', 'ebekero' ) . '</a>',
	);
	return array_merge($plugin_links, $links);
}
