<?php

class WC_eBekero_Payment_Gateway extends WC_Payment_Gateway {
	function __construct() {
		$this->id = "ebekero";

		$this->method_title = __( "eBekérő", 'ebekero' );
		$this->method_description = __( "A vevő magyar bankszámlaszámán keresztül, a Fizetési Kérelem szolgáltatáson keresztül fizet.", 'ebekero' );

		$this->title = __( "eBekérő", 'ebekero' );
		$this->icon = null;
		$this->has_fields = true;

		$this->init_form_fields();
		$this->init_settings();

		foreach ( $this->settings as $setting_key => $value )
			$this->$setting_key = $value;


        add_action( 'woocommerce_api_' . $this->id . '-start', array( $this, 'ebekero_start' ) );
        add_action( 'woocommerce_api_' . $this->id . '-notify', array( $this, 'ebekero_notify' ) );

		if (is_admin())
			add_action('woocommerce_update_options_payment_gateways_'.$this->id,
				array( $this, 'process_admin_options' )
			);
	}

	public function init_form_fields() {
		$this->form_fields = array(
			'enabled' => array(
				'title'		=> __( 'Bekapcsolás/Kikapcsolás', 'ebekero' ),
				'label'		=> __( 'Engedélyezze az eBekérős fizetést', 'ebekero' ),
				'type'		=> 'checkbox',
				'default'	=> 'no',
			),
			'title' => array(
				'title'		=> __( 'Fizetési mód neve', 'ebekero' ),
				'type'		=> 'text',
				'desc_tip'	=> __( 'A felhasználónak kiírt fizetési mód neve.', 'ebekero' ),
				'default'	=> __( 'eBekérő fizetés', 'ebekero' ),
			),
			'description' => array(
				'title'		=> __( 'Leírás', 'ebekero' ),
				'type'		=> 'textarea',
				'desc_tip'	=> __( 'Tájékoztatás a felhasználónak.', 'ebekero' ),
				'default'	=> __( 'eBekérő.hu regisztráció, vagy magyar bankszámlaszám használata fizetéshez', 'ebekero' ),
				'css'		=> 'max-width:450px;'
			),
			'creditor_name' => array(
				'title'		=> __( 'Eladó név', 'ebekero' ),
				'type'		=> 'text',
				'desc_tip'	=> __( 'Az eBekérő feladójának neve.', 'ebekero' ),
				'custom_attributes' => array( 'required' => 'required' )
			),
			'creditor_email' => array(
				'title'		=> __( 'Eladó e-mail cím', 'ebekero' ),
				'type'		=> 'email',
				'desc_tip'	=> __( 'A feladó emailcíme. Ez egy regisztrált céges fiók kell hogy legyen.', 'ebekero' ),
				'description' => __( 'Ezt a fiókot megelőzőleg regisztráld az eBekérő.hu felületen, és hitelesítsd is, mert enélkül nem fog működni a modul.', 'ebekero' ),
				'custom_attributes' => array( 'required' => 'required' ),
				'id'=>'creditor_email'
			),
			'environment' => array(
				'title'		=> __( 'Tesztmód használata', 'ebekero' ),
				'label'		=> __( 'Tesztszerver csatlakozás', 'ebekero' ),
				'type'		=> 'checkbox',
				'description' => __( 'A fizetési mód teszteléséhez érdemes az első pár kérést a tesztkörnyezet használatával végezni.', 'ebekero' ),
				'default'	=> 'yes',
			)
		);
	}

	public function validate_creditor_email_field($key, $value) {

		/* TODO client side sanity check
		include('library/eBekero.php');

		$api = new eBekero\eBekeroAPI();
		$api->setMode($api::SANDBOX);
		$response = $api->APIcall('profile/status', (object)['email'=>$value]);

		if(isset($response->category))
			if($response->category > 1)
				return $value;

		WC_Admin_Settings::add_error(__('A megadott emailcím jelenleg nem képes eBekérő feladására. A modul beállításához eBekérő regisztráció szükséges.'.var_dump($response, TRUE), 'ebekero' ) );
		*/


		return $value;
	}

	public function process_payment($order_id) {
		global $woocommerce;

        return array(
            'result'   => 'success',
            'redirect' => site_url('?wc-api=ebekero-start&order_id='.$order_id)
        );
	}

    public function ebekero_start() {
        $order_id = false;
        if(isset($_GET['order_id'])) $order_id = $_GET['order_id'];
        if(!$order_id) return;

        global $woocommerce;
        $customer_order = new WC_Order( $order_id );

        if($customer_order) {
            $bekero['creditor_name']    = $this->creditor_name;
            $bekero['creditor_email']   = $this->creditor_email;
            $bekero['order_id']         = $order_id;
            $bekero['amount']           = ceil($customer_order->order_total);

            $bekero['debtor_email']     = $customer_order->get_billing_email();
            $bekero['debtor_name']      = ($customer_order->billing_last_name
                                            . ' ' .
                                            $customer_order->billing_first_name);

            $style = plugins_url('library/ebekero-half.css', __FILE__);
            $js_bundle = plugins_url('library/bundle.js', __FILE__);
            $js_ebekero = plugins_url('library/ebekero.js', __FILE__);

			include('library/eBekero.php');
			$api = new eBekero\eBekeroAPI();
			if ($this->environment == 'yes') $api->setMode($api::SANDBOX);
			else                             $api->setMode($api::LIVE);

            $callback = site_url('?wc-api=ebekero-notify');
			$apiserver = $api->HOST;

            include_once('library/ebekero-fullpage.php');

        } else {
            echo 'Hiba';
        }
        die;
    }

    public function ebekero_notify() {
        $reference = false;
        if(isset($_GET['reference'])) $reference = $_GET['reference'];
        if(!$reference) wp_die('Nem létezik ilyen tranzakció.');


        include('library/eBekero.php');

        $bekero = new eBekero\eBekero();
		if ($this->environment == 'yes')
			$bekero->setMode($bekero::SANDBOX);
		else
			$bekero->setMode($bekero::LIVE);
        $bekero->setCreditor($this->creditor_email);
		$bekero->setReference($reference);
		$bekero->status();

        if($bekero->error->code) wp_die('Nem létezik ilyen tranzakció.');

		$order_id = $bekero->getCustom();
        global $woocommerce;
        $customer_order = new WC_Order( $order_id );
        if(!$customer_order) wp_die('Nincs ilyen rendelés.');

        $msg = 'eBekérő #'.$reference.': ';

        $states = ['failed', 'completed', 'processing'];

        $update = !in_array($customer_order->get_status(), $states);

        switch($bekero->getState()) {
            case $bekero->STATE_INIT:
            case $bekero->STATE_SENT:
            case $bekero->STATE_ACK:
                $msg .= ' '.__( 'a fizetési folyamat elindult, az állapot frissítése <a target="_blank" href="'.site_url('?wc-api=ebekero-notify').'&reference='.$reference.'&admin=1">itt lehetséges</a>', 'ebekero' );
                if($customer_order->get_status() != 'on-hold') $customer_order->add_order_note($msg, true);
                $customer_order->update_status('on-hold', '', false);
                break;
            case $bekero->STATE_DROP:
                $msg .= ' '.__( 'rendszer által elutasított fizetés', 'ebekero' );
                $customer_order->add_order_note($msg, true);
                $customer_order->update_status('failed', '', false);
                break;
            case $bekero->STATE_ACCEPT:
                $msg .= ' '.__( 'sikeres fizetés', 'ebekero' );
                if($update) $customer_order->add_order_note($msg, true);
                $customer_order->payment_complete();
    			$woocommerce->cart->empty_cart();
                break;
            case $bekero->REJECT:
                $msg .= ' '.__( 'elutasított fizetés', 'ebekero' );
                if($update) $customer_order->add_order_note($msg, true);
                $customer_order->update_status('failed', '', false);
                break;
            case $bekero->RECALL:
                $msg .= ' '.__( 'visszahívva tétlenség miatt', 'ebekero' );
                if($update) $customer_order->add_order_note($msg, true);
                $customer_order->update_status('failed', '', false);
                break;
        }

        if(isset($_GET['admin'])) wp_send_json("Frissitve");
        else if($customer_order->get_status() == 'failed') {
            wp_redirect(wc_get_checkout_url());
            exit();
        } else {
            wp_redirect($this->get_return_url($customer_order));
            exit();
        }
    }

	public function validate_fields() {
		return true;
	}
}
